(load "~/quicklisp/setup.lisp" :if-does-not-exist nil)

(require 'asdf)

(asdf:oos 'asdf:load-op :cffi)

(defpackage :nicesat
  (:use :common-lisp :cffi))

(in-package :nicesat)

(define-foreign-library libcffinice
    (:unix (:or "libcffinice.so.0" "libcffinice.so"))
  (t (:default "libcffinice")))

(define-foreign-library libnice
    (:unix (:or "libnice_opt.so.0" "libnice_opt.0.dylib"
                "libnice_opt.so"   "libnice_opt.dylib"
                "libnice_opt"))

  (t (:default "libnice_opt")))

(define-foreign-library libpicosat
    (:unix (:or "libpicosat.so.0" "libpicosat.0.dylib" 
                "libpicosat.so"   "libpicosat.dylib"
                "libpicosat"))

  (t (:default "libpicosat")))

(use-foreign-library libpicosat)
(use-foreign-library libnice)
(use-foreign-library libcffinice)
